// VMFSuite namespace.
VMFSuite = {
	// convars
	ConVars = {},
	
	// data
	Data = {},
	
	// configuration
	Config = {},
	
	// debug
	Debug = true,
	
};

// application framework.
include( "app_framework/manifest.lua" );

// controls
include( "controls/cl_ctl_rotation.lua" );
include( "controls/cl_ctl_translation.lua" );
include( "controls/cl_ctl_orientation.lua" );
include( "controls/cl_ctl_usereditor.lua" );
include( "controls/cl_ctl_clientsettings.lua" );
include( "controls/cl_ctl_settings.lua" );

// includes
include( "vmf-suite/shared/manifest.lua" );
include( "cl_usermessage.lua" );
include( "cl_spawnmenu.lua" );
include( "cl_progresswindow.lua" );
include( "cl_config.lua" );
include( "cl_preview.lua" );
include( "cl_flags.lua" );
include( "cl_admins.lua" );


// convars
VMFSuite.ConVars['rotation'] = {
	pitch = CreateClientConVar( "vmf_rotation_p", "0", true, true ),
	yaw = CreateClientConVar( "vmf_rotation_y", "0", true, true ),
	roll = CreateClientConVar( "vmf_rotation_r", "0", true, true ),
	
};
VMFSuite.ConVars['offset'] = {
	x = CreateClientConVar( "vmf_ofs_x", "0", true, true ),
	y = CreateClientConVar( "vmf_ofs_y", "0", true, true ),
	z = CreateClientConVar( "vmf_ofs_z", "0", true, true ),
	
};
VMFSuite.ConVars['surface_align'] = CreateClientConVar( "vmf_align_surface", "1", true, true );
VMFSuite.ConVars['spawn_unfrozen'] = CreateClientConVar( "vmf_spawn_unfrozen", "0", true, true );
VMFSuite.ConVars['spawn_frozen'] = CreateClientConVar( "vmf_spawn_frozen", "0", true, true );
VMFSuite.ConVars['weld_surface'] = CreateClientConVar( "vmf_weld_surface", "0", true, true );

// TODO: Add simple previews.
//
VMFSuite.ConVars['simple_previews'] = CreateClientConVar( "vmf_simple_previews", "0", true, false );

// language stuff.
language.Add( "Undone_VMF", "Undone VMF" );
language.Add( "Cleanup_VMF", "VMF" );
language.Add( "Cleaned_VMF", "Cleaned up all VMFs" );
	

// cleanup
cleanup.Register( "VMF" );
